//Note: Details of scilab software version and OS version used:
//OS: Windows 7
//Scilab version: 5.4.1
//IPD Atom version:8.3.1-2
//SIVP Atom version:0.5.3.1-2
clc;
clear all;
close;
n = 6; //filter order
Wn = [2.5e6,29e6]/500e6; //normalized cutoff frequencies[lower,upper]
ftype = 'bp'; //bandpass filter
fdesign = 'butt'; //Butterworth Filter
delta =[];
hz=iir(n,ftype,fdesign,Wn/2,delta)
[p,z,g]=iir(n,ftype,fdesign,Wn/2,delta)
[hzm,fr]=frmag(hz,256);
plot2d(fr',hzm');
xtitle('Discrete IIR filter band pass  0.005 < fr < 0.058 ',' ',' ');
xgrid(1)
//Result
  
//-->hz(2)
// ans  =
// 
//                          2            4      
//    0.0000002 - 0.0000015z + 0.0000037z       
//                        6            8        
//            - 0.0000049z + 0.0000037z         
//                        10           12       
//            - 0.0000015z + 0.0000002z         
// 
//-->hz(3)
// ans  =
// 
//                                       2      
//    0.5250468 - 6.6287407z + 38.377802z       
//                        3            4        
//            - 134.73451z + 319.45814z         
//                        5            6        
//            - 538.91189z + 663.25134z         
//                        7           8         
//            - 600.03003z + 396.0233z          
//                         9           10       
//            - 185.96443z + 58.974503z         
//                        11  12                
//            - 11.340535z + z                  
// 
//-->hz(1)
// ans  =
// 
//!r  num  den  dt  !
// 
//-->p
// p  =
// 
//    0.9964120 - 0.0154005i  
//    0.9892502 - 0.0129619i  
//    0.9822499 - 0.0060512i  
//    0.9822499 + 0.0060512i  
//    0.9892502 + 0.0129619i  
//    0.9964120 + 0.0154005i  
//    0.9464056 + 0.1686845i  
//    0.8907712 + 0.1177110i  
//    0.8651786 + 0.0429743i  
//    0.8651786 - 0.0429743i  
//    0.8907712 - 0.1177110i  
//    0.9464056 - 0.1686845i  
// 
//-->z
// z  =
// 
//    1.  
//    1.  
//    1.  
//    1.  
//    1.  
//    1.  
//  - 1.  
//  - 1.  
//  - 1.  
//  - 1.  
//  - 1.  
//  - 1.  
// 
//-->g
// g  =
// 
//    0.0000002  
// 
